# LIGO-Virgo GWTC-3 Tests of GR

## Consistency Tests: Inspiral-Merger-Ringdown Test

Data release for the inspiral-merger-ringdown consistency test, Sec. IVB in Abbott et al (2021), _Tests of General Relativity with GWTC-3_.

### Contents

-  `utils_imrct.py`: Utility functions for post-processing the IMR results and producing plots.
-  `imrct_plot_hier.ipynb`: Jupyter notebook to produce plots for the hierarchical analysis.
-  `imrct_plot.py`: python script to produce plots for 2D and 1D likelihoods for all events and the joint likelihoods.
-  `./likelihoods/`: Contains `*.dat.gz` files with the likelihoods for individual events.
- `./macros`  macro files used in the paper. 
- `./cache/GWTC*`: folders containing `*txt.gz` files with the hyperparameter posteriors, divided by observing run. 
- `./fig`: contains figures shown in the paper.

Please see comments within each Jupyter notebook for further details.

### Environment

This code is designed to run under the `gwtc3-tgr` Conda environment shipped with this release. You can create this environment from the enclosed `environment.yml` file by doing
```
conda env create -f environment.yml
```
Note that this environment is the same for all tests in this paper, so you only need to install it once. You can activate it with
```
conda activate gwtc3-tgr
```
after that, you should be able to start `jupyter-lab` to open the Jupyter notebooks in this release.

For help installing Conda, see the [documentation](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

### Acknowledgement

If you make use of these data or software in your own work, please include the following acknowledgement:

"This research has made use of data, software and/or web tools obtained from the Gravitational Wave Open Science Center (https://www.gw-openscience.org/), a service of the LIGO Laboratory, the LIGO Scientific Collaboration and the Virgo Collaboration. LIGO is funded by the U.S. National Science Foundation. Virgo is funded, through the European Gravitational Observatory (EGO), by the French Centre National de Recherche Scientifique (CNRS), the Italian Istituto Nazionale della Fisica Nucleare (INFN) and the Dutch Nikhef, with contributions by institutions from Belgium, Germany, Greece, Hungary, Ireland, Japan, Monaco, Poland, Portugal, Spain."

### License

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
