# LIGO-Virgo GWTC-3 Tests of GR

## Parametrized tests

Data release for parametrized tests of gravitational-wave generation, Sec. VA in Abbott et al (2021), _Tests of General Relativity with GWTC-3_.

### Contents
- Data
   1. `./individual`: contains `*dat.gz` files with the posteriors on the deviation coefficients for individual events.
   2. `./combined`: contains `*dat.gz` and `*.npy` files with the combined posteriors, both for the joint-likelihood and the hierarchical methods.
   3. `./hyperparams`: contains `*dat.gz` files with the hyperparameter posteriors for the deviation coefficients.  
   4. `./bounds`: contains `*.pkl` files with the upper bounds on the absolute magnitude of the deviation coefficients. 
- Utilities required to run plotting scripts
   1. `par_utils.py`: Utility functions for producing plots.
   2. `posteriors_utils.py`: Utility functions for handling settings of plots.
   3. `./hier/par_plotter.py`: Utility functions used to produce contour and violin plots.
- Plotting scripts
   1. `par_plot_bounds.ipynb`: Jupyter notebook to produce the absolute bounds plots in the paper.
   2. `./hier/par_violin.ipynb`: Jupyter notebook to produce the violin plots of Fig. 7, as well as Tab. VI 
   3. `./hier/2D_contour_hier.ipynb`: Jupyter notebook to produce Fig. 8
- Tables and figures 
   1. `par_bounds_seob.pdf`: Fig. 6 of the paper.
   2. `./hier/tab_par.tex`: Tab. VI of the paper.
   3. `./hier/par_violin_seob.pdf`: Fig. 7 of the paper.
   4. `./hier/par_hier_contour.pdf`: Fig. 8 of the paper.
 

Please see comments within Jupyter notebook for further details.

### Environment

This code is designed to run under the `gwtc3-tgr` Conda environment shipped with this release. You can create this environment from the enclosed `environment.yml` file by doing
```
conda env create -f environment.yml
```
Note that this environment is the same for all tests in this paper, so you only need to install it once. You can activate it with
```
conda activate gwtc3-tgr
```
after that, you should be able to start `jupyter-lab` to open the Jupyter notebooks in this release.

For help installing Conda, see the [documentation](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

### Acknowledgement

If you make use of these data or software in your own work, please include the following acknowledgement:

"This research has made use of data, software and/or web tools obtained from the Gravitational Wave Open Science Center (https://www.gw-openscience.org/), a service of the LIGO Laboratory, the LIGO Scientific Collaboration and the Virgo Collaboration. LIGO is funded by the U.S. National Science Foundation. Virgo is funded, through the European Gravitational Observatory (EGO), by the French Centre National de Recherche Scientifique (CNRS), the Italian Istituto Nazionale della Fisica Nucleare (INFN) and the Dutch Nikhef, with contributions by institutions from Belgium, Germany, Greece, Hungary, Ireland, Japan, Monaco, Poland, Portugal, Spain."

### License

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

