# Copyright 2016 Jeroen Meidam <jmeidam@nikhef.nl>
#
# Modified for O2 by Ka Wa Tsang, Laura van der Schaaf, Archisman Ghosh
#
# Modified for O3a by Geraint Pratten
# Modified for O3b by Marta Colleoni

import sys, os
from os import path, makedirs

import numpy as np
from numpy import load, save, searchsorted, random, cumsum, savetxt, genfromtxt, array, linspace

from copy import deepcopy
from scipy.stats import gaussian_kde

import seaborn as sns
import matplotlib.pyplot as plt

from par_utils import convert_genericFD_to_TIGER
import glob


gwtc = ['GW150914','GW151226','GW170104','GW170608','GW170814']

settings={
            'combinedposterior_samples' : 5000, # Number of samples to draw from the combined pdf
            'kde_cov_factor'    : 0.25,
            'kde_points'        : 1000,
}
            

def initialize(settings
):
    """
      Check paths and files used in postprocessing
    """
    waveform = settings['waveform']
    
    if(os.path.isdir(settings['output_path'])==False):
        os.mkdir(settings['output_path'])
    
    if(settings['gwtc'] > 1):
        if(settings['inspiral']):
            datafile = path.join(settings['output_path'],'posteriors_combined_inspiral_'+waveform)
        elif(settings['post-inspiral']):
            datafile = path.join(settings['output_path'],'posteriors_combined_post-inspiral_'+waveform)
        else:
            print('Error: settings[\'inspiral\'] or settings[\'post-inspiral\'] must be True.')
    else:
        if(settings['inspiral']):
            datafile = path.join(settings['output_path'],'posteriors_combined_inspiral_'+waveform+'_gwtc')
        elif(settings['post-inspiral']):
            datafile = path.join(settings['output_path'],'posteriors_combined_post-inspiral_'+waveform+'_gwtc')
        else:
            print('Error: settings[\'inspiral\'] or settings[\'post-inspiral\'] must be True.')

    parameters = {}
    
    events              = settings['events']
        
    for p in settings['parameters']:
        parameters[p] = parameter(p,events,settings)
            
    print('Saving data to : ', datafile)
    save(datafile,parameters)

    return parameters




def set_events_to_use(settings,o1o2_inspiral=['GW150914', 'GW151226', 'GW170104', 'GW170608', 'GW170814'],o1o2_postinspiral=['GW150914', 'GW170104', 'GW170608', 'GW170809','GW170814','GW170823'],o3a_inspiral=['GW190408A', 'GW190412A', 'GW190512A', 'GW190521B', 'GW190630A', 'GW190707A', 'GW190708A', 'GW190720A', 'GW190728A', 'GW190814A', 'GW190828A', 'GW190828B', 'GW190924A'], o3b_inspiral=['GW200316A', 'GW200311B', 'GW200225A', 'GW200202A', 'GW200129A', 'GW200115', 'GW191216A', 'GW191204B', 'GW191129A'],o3_postinspiral=['GW190408A', 'GW190412A', 'GW190421A', 'GW190503A', 'GW190512A', 'GW190513A', 'GW190517A', 'GW190519A', 'GW190521A', 'GW190521B', 'GW190602A', 'GW190630A', 'GW190706A', 'GW190708A', 'GW190727A', 'GW190814A', 'GW190828A', 'GW190828B', 'GW190910A', 'GW190915A', 'GW191222A', 'GW191109A', 'GW191204B', 'GW191215A', 'GW191216A', 'GW200129A', 'GW200208A', 'GW200219A', 'GW200224B', 'GW200225A', 'GW200311B'],o3b_postinspiral=['GW191109A', 'GW191204B', 'GW191215A', 'GW191216A', 'GW191222A', 'GW200129A', 'GW200208A', 'GW200219A', 'GW200224B', 'GW200225A', 'GW200311B'],o3b_only=False):
    
    if settings['gwtc']> 1:
        # Events meeting SNR > 6 in inspiral. The if(settings['waveform']) are temporary until data curated.
        
        if(settings['inspiral']):
            
            if(settings['gwtc']==2):
                settings['events'] = o1o2_inspiral+o3a_inspiral
            elif(settings['gwtc']==3):
                if(o3b_only==False):
                    settings['events'] = o1o2_inspiral+o3a_inspiral+o3b_inspiral
                else:
                    settings['events'] = o3b_inspiral

        # Events meeting SNR > 6 in post-inspiral
        elif(settings['post-inspiral']):
            # Only use IMRPhenomPv2
            if(settings['gwtc']<3):
                settings['events'] = o1o2_postinspiral+o3_postinspiral 
            else:
                settings['events'] = o3b_postinspiral
        # Settings are wrong
        else:
            print('Error: settings[\'inspiral\'] and settings[\'post-inspiral\'].')
    else:
        if(settings['inspiral']):
            settings['events'] = o1o2_inspiral
        elif(settings['post-inspiral']):
            settings['events'] = o1o2_postinspiral
        else:
            print('Error: settings[\'inspiral\'] and settings[\'post-inspiral\'].')
     
    # Print waveform and events used
    print('Waveform     : ',settings['waveform'])
    if(settings['inspiral'] == True):
        print('Regime       :  inspiral')
    if(settings['post-inspiral'] == True):
        print('Regime       :  post-inspiral')
    print('Using events : ')
    for ev in settings['events']:
        print('   ',ev)
        

def set_parameters_to_use(settings):
    if(settings['inspiral']):
        # Use inspiral coeffcients
        settings['parameters']  = ['dphi-2','dphi0','dphi1','dphi2','dphi3','dphi4','dphi5l','dphi6','dphi6l','dphi7'] 

    elif(settings['post-inspiral']):
        # Use post-inspiral coeffcients
  
        settings['parameters']  = ['dbeta2','dbeta3','dalpha2','dalpha3','dalpha4']

    else:
        print('Error: settings[\'inspiral\'] and settings[\'post-inspiral\'].')

    print('Creating combined posteriors for parameters : ',settings['parameters'])
