# LIGO-Virgo GWTC-3 Tests of GR

## pyRing analysis

Data release for pyRing analysis, Sec. VIII.A.1 in Abbott et al (2021), _Tests of General Relativity with GWTC-3_.

### Contents

- `plot_hier.ipynb`: Jupyter notebook to produce the plot for the pyRing analysis in the paper.
- `tabulate_pyring_results.py`: Python script to tabulate results from the pyRing analysis.
- `tabulate_freq_tau_results.py`: Python script to tabulate results from the IMR and pyRing analysis.
- `rin_pyring_skyloc.json`: JSON file containing the sky locations for each event for the pyRing analysis.
- `rin_pyring_log10_BFs_HM_vs_noHM.json`: JSON file containing the log Bayes factor for the Kerr_221 waveform model vs the Kerr_220 waveform model from the pyRing analysis.
- `rin_pyring_log10_BFs_OT_vs_noOT.json`: JSON file containing the log Bayes factor for the Kerr_HM waveform model vs the Kerr_220 waveform model from the pyRing analysis.
- `rin_pyring_log10_BFs_TIGER_modGR_vs_GR.json`: JSON file containing the log odds ratio of the modified GR hypothesis vs the GR hypothesis from the pyRing analysis.
- `S*/`: one directory per event containing dat.gz files storing the posterior samples of the remnant mass and spin, the QNM oscillation frequency and damping time from each of the analyses (IMR, pyRing)
- `Hierarchical_gwtc2`: directory containing hierarchically combined results of the pyRing analysis for GWTC2 (https://dcc.ligo.org/LIGO-P2000438).
- `Hierarchical_gwtc3`: directory containing hierarchically combined results of the pyRing analysis for GWTC3.
- `utils.py`: GWTC-3 testing-GR utilities (requires enclosed `*.pkl` files).

Please see comments within Jupyter notebook for further details.

### Environment

This code is designed to run under the `gwtc3-tgr` Conda environment shipped with this release. You can create this environment from the enclosed `environment.yml` file by doing
```
conda env create -f environment.yml
```
Note that this environment is the same for all tests in this paper, so you only need to install it once. You can activate it with
```
conda activate gwtc3-tgr
```
after that, you should be able to start `jupyter-lab` to open the Jupyter notebooks in this release.

For help installing Conda, see the [documentation](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

### Acknowledgement

If you make use of these data or software in your own work, please include the following acknowledgement:

"This research has made use of data, software and/or web tools obtained from the Gravitational Wave Open Science Center (https://www.gw-openscience.org/), a service of the LIGO Laboratory, the LIGO Scientific Collaboration and the Virgo Collaboration. LIGO is funded by the U.S. National Science Foundation. Virgo is funded, through the European Gravitational Observatory (EGO), by the French Centre National de Recherche Scientifique (CNRS), the Italian Istituto Nazionale della Fisica Nucleare (INFN) and the Dutch Nikhef, with contributions by institutions from Belgium, Germany, Greece, Hungary, Ireland, Japan, Monaco, Poland, Portugal, Spain."

### License

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
