# LIGO-Virgo GWTC-3 Tests of GR

## Gravitational wave generation: spin-induced quadrupole moment

Data release for measurements of the spin-induced quadrupole moment, Sec. VB in Abbott et al (2021), _Tests of General Relativity with GWTC-3_.

### Contents

- `simplot.ipynb`: Jupyter notebook to produce plots and macros in paper.
- `sim_dkappa_sym_GW*`: `*dat.gz` files containing 1D posteriors for $`\delta\kappa_s`$ for the event specified in the file name.
- `./hier_analysis/cache/sim/O1O2O3/`: contains `*.dat.gz` files with the population hyperparameters. 
- `sim_sym_posdk.pdf`: Fig. 9 of the paper.
- `sim_combined.pdf`: Fig. 10 of the paper.


Please see comments within Jupyter notebook for further details.

### Environment

This code is designed to run under the `gwtc3-tgr` Conda environment shipped with this release. You can create this environment from the enclosed `environment.yml` file by doing
```
conda env create -f environment.yml
```
Note that this environment is the same for all tests in this paper, so you only need to install it once. You can activate it with
```
conda activate gwtc3-tgr
```
after that, you should be able to start `jupyter-lab` to open the Jupyter notebooks in this release.

For help installing Conda, see the [documentation](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

### Acknowledgement

If you make use of these data or software in your own work, please include the following acknowledgement:

"This research has made use of data, software and/or web tools obtained from the Gravitational Wave Open Science Center (https://www.gw-openscience.org/), a service of the LIGO Laboratory, the LIGO Scientific Collaboration and the Virgo Collaboration. LIGO is funded by the U.S. National Science Foundation. Virgo is funded, through the European Gravitational Observatory (EGO), by the French Centre National de Recherche Scientifique (CNRS), the Italian Istituto Nazionale della Fisica Nucleare (INFN) and the Dutch Nikhef, with contributions by institutions from Belgium, Germany, Greece, Hungary, Ireland, Japan, Monaco, Poland, Portugal, Spain."

### License

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
