### List of bounds

Check each individual file to find out precisely which constraint I'm using.
Constraints which are not *strictly* valid for monochromatic mass functions are marked with an asterisk (*). Projected constraints are marked with a dagger (†). Constraints which are now generally discredited are marked with a 'slashed zero' (ø).

- **3G-GW-1y**, **3G-GW-10y**†: Projected constraints from 3G Gravitational Wave detectors (based on 1 year and 10 years of operation) - [arXiv:2111.06990](https://arxiv.org/abs/2111.06990)  
- **511keV**: Constraints on PBH evaporation from the 511 keV gamma ray line - [arXiv:1906.09994](https://arxiv.org/abs/1906.09994) and [arXiv:1906.07740](https://arxiv.org/abs/1906.07740) 
- **511keV-DeLaTorreLuque2024**: Updated PBH evaporation constraints from 511 keV line - [arXiv:2406.11949](https://arxiv.org/abs/2406.11949)  
- **AMS**: Constraints from AMS-02, due to positron + electron production by evaporation - [arXiv:2403.04988](https://arxiv.org/abs/2403.04988)  
- **Comptel**: Constraints from PBH evaporation using Comptel GC observations - [arXiv:2010.04797](https://arxiv.org/abs/2010.04797)  
- **CMB**: Constraints from modification of the CMB spectrum due to accreting PBHs, including particle DM accretion - [arXiv:2002.10771](https://arxiv.org/abs/2002.10771) 
- **CMB-Agius2024**: Updated CMB constraints from accreting PBHs, assuming Park-Ricotti accretion model - [arXiv:2403.18895](https://arxiv.org/abs/2403.18895)  
- **CMBevap**: Constraints from modification of the CMB spectrum due to evaporating PBHs - [arXiv:1612.07738](https://arxiv.org/abs/1612.07738)
- **EROS**: Microlensing constraints from EROS - [astro-ph/0607207](https://arxiv.org/abs/astro-ph/0607207)  
- **EDGES**: Constraints from energy injection in the 21cm EDGES signal due to accreting PBHs - [arXiv:1803.09697](https://arxiv.org/abs/1803.09697)  
- **EDGESevap-Clark2018**: Constraints from energy injection in the 21cm EDGES signal due to evaporating PBHs - [Clark et al., arXiv:1803.09390](https://arxiv.org/abs/1803.09390)  
- **EDGESevap-Mittal2021**: Constraints from energy injection in the 21cm EDGES signal due to evaporating PBHs - [Mittal et al., arXiv:2107.02190](https://arxiv.org/abs/2107.02190)
- **EDGESevap-Saha2021**: Constraints from energy injection due to evaporating PBHs (rotating and non-rotating), leading to an EDGES-like 21cm signal - [Saha & Laha, arXiv:2112.10794](https://arxiv.org/abs/2112.10794)  
- **EGRB**: Constraints on PBH evaporation from extragalactic gamma-rays - [arXiv:0912.5297](https://arxiv.org/abs/0912.5297)  
- **FLø**: Femto-lensing of gamma-ray bursts - [arXiv:1204.2056](https://arxiv.org/abs/1204.2056)  
- **FL-small†**: Femto-lensing of small gamma-ray bursts - [arXiv:1807.11495](https://arxiv.org/abs/1807.11495)  
- **FRB**: Non-observation of lensing of Fast Radio Bursts - [arXiv:2003.13349](https://arxiv.org/abs/2003.13349)
- **FRB-Leung2022**: Updated constraints on FRB Lensing with CHIME/FRB - [arXiv:2204.06001](https://arxiv.org/abs/2204.06001)  
- **GECCO†**: Projections for evaporation constraints from MeV-gamma ray telescope GECCO - [arXiv:2101.10370](https://arxiv.org/abs/2101.10370)
- **GRB-parallax†**: Lensing parallax of 1000 GRBs (using spatially separated telescopes) - [arXiv:1908.00078](https://arxiv.org/abs/1908.00078)  
- **GW-lensing†**: Microlensing of GWs by PBHs - [arXiv:1712.01396](https://arxiv.org/abs/1712.01396)  
- **HSC**: Microlensing constraints from the Hyper-Supreme Cam - [arXiv:1701.02151](https://arxiv.org/abs/1701.02151), updated in [arXiv:1910.01285](https://arxiv.org/abs/1910.01285) and then again in [arXiv:2007.12697](https://arxiv.org/abs/2007.12697) 
- **Icarus**: Icarus microlensing event ('caustic crossing') - [arXiv:1710.00148](https://arxiv.org/abs/1710.00148)  
- **INTEGRAL**: Constaints from MeV background from evaporating PBHs - [arXiv:2004.00627](https://arxiv.org/abs/2004.00627)  
- **K**: Microlensing constraints from Kepler - [arXiv:1307.5798](https://arxiv.org/abs/1307.5798)  
- **Leo-I**: Dynamics of Leo-I -  [arXiv:1906.10463](https://arxiv.org/abs/1906.10463)  
- **Leo-T**: Heating due to dynamic friction and accretion in Leo T - [arXiv:2007.02213](https://arxiv.org/abs/2007.02213)  
- **Leo-Tevap**: Heating due to evaporation in dwarf galaxy Leo T - [arXiv:2007.07739](https://arxiv.org/abs/2007.07739)  
- **LIGO**: Direct constraints on PBH-PBH mergers with LIGO - [arXiv:1805.09034](https://arxiv.org/abs/1805.09034) and [arXiv:1904.08976](https://arxiv.org/abs/1904.08976)  
- **LIGO-perturbed**: Conservative constraints on PBH-PBH mergers incorporating effects of binary perturbations - [arXiv:1908.09752](https://arxiv.org/abs/1908.09752)  
- **LIGO-HMR***: Constraints on PBH-PBH mergers in which one PBH is ~37 solar mass and the other is sub-solar - [arXiv:2202.11024](https://arxiv.org/abs/2202.11024) 
- **LIGO-subsolar**: Constraints on PBH fraction from direct searches for gravitational waves from subsolar mass binary black hole mergers in LVK O1+O2+O3 data - [arXiv:2202.11024](https://arxiv.org/abs/2202.11024)
- **LIGO-SGWB-O2**: Stochastic BG of PBH mergers with LIGO (Observing Run 2) - [arXiv:1904.02396](https://arxiv.org/abs/1904.02396)
- **LIGO-SGWB-O3**: Stochastic BG of PBH mergers with LIGO (Observing Run 3) - [arXiv:2202.11024](https://arxiv.org/abs/2202.11024)  
- **LIGO-SGWB-O1-O2-O3**: Stochastic BG of PBH mergers with the first three LIGO observing runs. Bayesian constraints using a narrow log-normal mass function ("MN prior") - [arXiv:2412.18318](https://arxiv.org/abs/2412.18318)  
- **LVK-SGWB-subsolar**: Stochastic GW background constraints for LVK O3 run - [arXiv:2202.11024](https://arxiv.org/abs/2202.11024)
- **LyaEvap-Khan2025**: Constraints on evaporating PBHs from Lyman-alpha forest temperature measurements - [Khan et al., arXiv:2503.15595](https://arxiv.org/abs/2503.15595)  
- **Lyalphaforest**: Ly-alpha forest constraint from the shot noise power spectrum [arXiv:1903.10509](https://arxiv.org/abs/1903.10509)
- **M**: Microlensing constraints from MACHO - [astro-ph/0011506](https://arxiv.org/abs/astro-ph/0011506)  
- **Microlensing**: envelope of EROS, HSC, K and M  
- **Microlensing-LongDuration**: Constraints from long-duration microlensing, combining EROS and MACHO results - [arXiv:2202.13819](https://arxiv.org/abs/2202.13819)  
- **NANOGrav**: Scalar-induced GWs with NANOGrav - [arXiv:1910.12239](https://arxiv.org/abs/1910.12239)
- **NSø**: Neutron star capture and destruction - [arXiv:1301.4984](https://arxiv.org/abs/1301.4984)  
- **OGLE-highcadence**: Constraints on planetrary mass PBHs from high-cadence OGLE observations - [arXiv:2410.06251](https://arxiv.org/pdf/2410.06251)  
- **OGLE-strict**: Most recent OGLE bounds from 20 year observations (OGLE-III + OGLE-IV), assuming no PBH-induced microlensing events. Other options are **OGLE-MW1** and **OGLE-MW2**, which correspond to the Cautun+ (2020) and Han & Gould (2003) Milky Way models respectively - [arXiv:2403.02398](https://arxiv.org/abs/2403.02398), [arXiv:2403.02386](https://arxiv.org/abs/2403.02386)
- **OGLE-hint**: Hint for Earth mass PBHs with OGLE - [arXiv:1901.07120](https://arxiv.org/abs/1901.07120)
- **OGLE-2019**: Microlensing constraints from OGLE 5-year observations - [arXiv:1901.07120](https://arxiv.org/abs/1901.07120)  
- **PBH-EMRIs†**: Extreme mass-ratio inspirals of PBHs around supermassive black holes - [arXiv:1910.07397](https://arxiv.org/abs/1910.07397)  
- **PTA-Doppler†**: PBH-induced motions in Pulsar Timing Arrays - [arXiv:1901.04490](https://arxiv.org/abs/1901.04490)  
- **PTA-Shapiro†**: PBH-induced time delays in Pulsar Timing Arrays - [arXiv:1901.04490](https://arxiv.org/abs/1901.04490)  
- **Quasars**: Constraints from microlensing of quasars - [arXiv:2203.04777](https://arxiv.org/abs/2203.04777)
- **Quasars-Xray**: Constraints from visible and X-ray microlensing of quasars (including and extending results of **Quasars**, arXiv:2203.04777, to lower masses) - [arXiv:2307.07473](https://arxiv.org/abs/2307.07473)  
- **Radio**: Radio constraints on accreting PBHs in the Milky Way - [arXiv:1812.07967](https://arxiv.org/abs/1812.07967)  
- **SKA†**: Forecast for the 21 cm power spectrum from SKA - [arXiv:1906.07735](https://arxiv.org/abs/1906.07735)  
- **SNe-Lensing**: Lensing of supernovae by PBHs - [arXiv:1712.02240](https://arxiv.org/abs/1712.02240)  
- **SuperK**: Bounds from evaporation into neutrinos from SuperKamiokande - [arXiv:1912.01014](https://arxiv.org/abs/1912.01014)  
- **UFdwarfs**: Constraints from the disruption of ultra-faint dwarfs - [arXiv:1605.03665](https://arxiv.org/abs/1605.03665)  
- **WhiteDwarfmicro†**: Projected microlensing constraints assuming observation of 1000 White Dwarfs in the LMC - [arXiv:1905.06066](https://arxiv.org/abs/1905.06066)
- **Voyager**: Constraints on PBH evaporation from electron/positron measurements by Voyager 1 probe - [arXiv:1807.03075](https://arxiv.org/abs/1807.03075)  
- **Voyager-DeLaTorreLuque2024**: Updated constraints on PBH evaporation from electron/positron measurements by Voyager 1 probe - [arXiv:2406.11949](https://arxiv.org/abs/2406.11949)  
- **WideBinaries**: Constraints from disruption of Wide Binaries - [arXiv:1406.5169](https://arxiv.org/abs/1406.5169)  
- **WDø**: Constraints from the destruction of White Dwarfs by PBHs - [arXiv:1505.04444](https://arxiv.org/abs/1505.04444)   
- **X-ray**: X-ray constraints on accreting PBHs in the Milky Way - [arXiv:1812.07967](https://arxiv.org/abs/1812.07967)   
- **Xrayevap**: X-ray background constraint from evaporating PBHs - [arXiv:2404.17119](https://arxiv.org/abs/2404.17119)  
- **Xrayevap-DeLaTorreLuque2024**: X-ray background constraint from evaporating PBHs (with XMM-Newton) - [arXiv:2406.11949](https://arxiv.org/abs/2406.11949)
- **Xraylensing-NICER**: Constraints from X-ray microlensing with NICER (1.74d) - [arXiv:2405.20365](https://arxiv.org/abs/2405.20365)    
- **Xraylensing-eXTP-proj†**: Projected constraints from microlensing of X-ray pulsars - [arXiv:1812.01427](https://arxiv.org/abs/1812.01427)
- **Xraylensing-NICER-proj†**: Projected constraints from X-ray microlensing with NICER (60d) - [arXiv:2405.20365](https://arxiv.org/abs/2405.20365)   
- **Xraylensing-STROBEX-proj†**: Projected constraints from X-ray microlensing with STROBE-X (30d) - [arXiv:2405.20365](https://arxiv.org/abs/2405.20365)  
- **Xraylensing-Xmu-proj†**: Projected constraints from X-ray microlensing with Xmu (30d) - [arXiv:2405.20365](https://arxiv.org/abs/2405.20365)  

